# Mental Health Themes Website

This project is a React application showcasing various themes designed for a mental health service website. It uses Vite for fast development and TypeScript for type safety.

## Project Structure

- `public/`: Contains static assets like images. Your theme images (from `Royalty-Free`, `Swatches`, `Borders` folders) should be placed in `public/images/`.
- `src/`:
  - `App2.tsx`: The main application component that includes a theme switcher.
  - `main.tsx`: The entry point for the React application.
  - `style.css`: Global styles for the application.
  - `context/`:
    - `floral theme.tsx`, `floral theme.css`: Components and styles for the Floral theme.
    - `sleekCafeBarTheme.tsx`, `sleekCafeBarTheme.css`: Components and styles for the Sleek Cafe Bar theme.
    - `firesideCabinTheme.tsx`, `firesideCabinTheme.css`: Components and styles for the Fireside Cabin theme.
    - `briskNightTheme.tsx`, `briskNightTheme.css`: Components and styles for the Brisk Night Sky theme.
    - `cursor ideas.txt`: Your file for notes and image suggestions.
- `index.html`: The main HTML file.
- `package.json`: Project dependencies and scripts.
- `vite.config.ts`: Vite configuration.
- `tsconfig.json`, `tsconfig.node.json`: TypeScript configurations.

## Getting Started

1.  **Install Dependencies:**
    Open your terminal in the project root directory (`coda/`) and run:
    ```bash
    npm install
    ```
    (or `yarn install` if you prefer yarn)

2.  **Set up Image Paths:**
    - Ensure your image folders (`Royalty-Free`, `Swatches`, `Borders`, and any `found` images) are placed inside `coda/public/images/`.
    - Verify that the image paths in all `*.tsx` theme files (e.g., `src/context/floral theme.tsx`) correctly point to these images (e.g., `/images/Royalty-Free/your-image.jpg`).

3.  **Customize Colors:**
    - Open the `*.css` file for each theme (e.g., `src/context/floral theme.css`).
    - Replace the placeholder color values with your chosen HEX or RGBA codes. Use the comments in the CSS files as guidance.

4.  **Run the Development Server:**
    ```bash
    npm run dev
    ```
    (or `yarn dev`)
    This will start the Vite development server, typically at `http://localhost:5173` (Vite's default, might vary).

5.  **Preview Themes:**
    Open the application in your browser. Use the theme switcher UI at the top of the page in `App2.tsx` to select different themes and toggle between light/dark modes.

## Available Scripts

In the project directory, you can run:

- `npm run dev`: Runs the app in development mode.
- `npm run build`: Builds the app for production.
- `npm run lint`: Lints the project files.
- `npm run preview`: Serves the production build locally.

## Learn More

To learn more about Next.js, take a look at the following resources:

- [Next.js Documentation](https://nextjs.org/docs) - learn about Next.js features and API.
- [Learn Next.js](https://nextjs.org/learn) - an interactive Next.js tutorial.

You can check out [the Next.js GitHub repository](https://github.com/vercel/next.js) - your feedback and contributions are welcome!

## Deploy on Vercel

The easiest way to deploy your Next.js app is to use the [Vercel Platform](https://vercel.com/new?utm_medium=default-template&filter=next.js&utm_source=create-next-app&utm_campaign=create-next-app-readme) from the creators of Next.js.

Check out our [Next.js deployment documentation](https://nextjs.org/docs/app/building-your-application/deploying) for more details.
